/*
 *  productInfo.js
 *
 *  Copyright: (c) 2018 FileMaker, Inc. All rights reserved.
 *
 *  FILEMAKER CONFIDENTIAL
 *  This file includes unpublished proprietary source code of FileMaker,
 *  Inc. The copyright notice above does not evidence any actual or
 *  intended publication of such source code.
 */
'use strict';

var path = require('path');
var fs = require('fs');
var app = require('../app');

module.exports.productInfo = function (req, res, next) {
    //FMPD-16623: Remove buildDate and version info from the response.
    var productVers = {
        "response": {
            "productInfo": {
                "name": "FileMaker Data API Engine",
                "dateFormat": "MM/dd/yyyy",
                "timeFormat": "HH:mm:ss",
                "timeStampFormat": "MM/dd/yyyy HH:mm:ss"
            }
        },
        "messages": [
            { "code": "0", "message": "OK" }
        ]
    }
    res.set('Content-Type', 'application/json');
    res.end(JSON.stringify(productVers))

}
